<?php
namespace SabaiApps\Directories\Component\Location\Api;

class GoogleMapsPlacesApi extends AbstractGoogleMapsApi implements IPlacesApi
{
    protected function _doGetInfo()
    {
        return [
            'label' => __('Google Maps Place Details', 'directories-pro'),
        ];
    }

    public function locationApiLoad(array $settings)
    {
        $this->_load('places');
    }

    public function locationApiGetPlaceRating($placeId, array $settings)
    {
        $result = $this->_request($placeId, $settings);
        return [
            'rating' => $result->rating,
            'count' => $result->user_ratings_total,
        ];
    }

    public function locationApiGetPlaceOpeningHours($placeId, array $settings)
    {
        return $this->_request($placeId, $settings)->opening_hours;
    }

    protected function _request($placeId, array $settings)
    {
        $url = $this->_application->Map_GoogleMapsApi_url('/place/details/json', [
            'key' => $settings['api']['key'],
            'place_id' => $placeId,
        ]);
        return $this->_application->Map_GoogleMapsApi_request($url)->result;
    }
}