<?php
namespace SabaiApps\Directories\Component\DirectoryPro\SystemWidget;

use SabaiApps\Directories\Component\System\Widget\AbstractWidget;

class FiltersSystemWidget extends AbstractWidget
{    
    protected $_cacheable = false;
    
    protected function _systemWidgetInfo()
    {
        return [
            'title' => __('Filter Form', 'directories-pro'),
            'summary' => __('Displays a filter form.', 'directories-pro'),
        ];
    }
    
    protected function _getWidgetSettings(array $settings)
    {
        $directory_options = [];
        foreach ($this->_application->getModel('Directory', 'Directory')->fetch() as $directory) {
            if (!$this->_application->Directory_Types_impl($directory->type, true)) continue; // make sure the directory type is active
            
            $directory_options[$directory->name] = $directory->getLabel();
        }
        if (empty($directory_options)) return;
        
        $directory_option_keys = array_keys($directory_options);
        return [
            'directory' => [
                '#title' => __('Select directory', 'directories-pro'),
                '#options' => $directory_options,
                '#type' => count($directory_options) <= 1 ? 'hidden' : 'select',
                '#default_value' => array_shift($directory_option_keys),
            ],
            'hide_on_mobile' => [
                '#title' => __('Hide on mobile', 'directories-pro'),
                '#type' => 'checkbox',
                '#default_value' => false,
            ],
        ];
    }
    
    protected function _getWidgetContent(array $settings)
    {
        if (!isset($settings['directory'])
            || !strlen($settings['directory'])
            || (!empty($settings['hide_on_mobile']) && $this->_application->isMobile())
        ) return;

        foreach ($this->_application->Entity_Bundles(null, 'Directory', $settings['directory']) as $_bundle) {
            if (!empty($_bundle->info['is_primary'])) {
                $bundle = $_bundle;
                break;
            }
        }
        if (!isset($bundle)) return;

        return '<div class="drts-view-entities-filter-form-placeholder" data-bundle-group="' . $bundle->group . '" data-bundle-type="' . $bundle->type . '"></div>';
    }
}