"use strict";

(function($) {
  DRTS.DirectoryPro = DRTS.DirectoryPro || {};
  DRTS.DirectoryPro.openingHours = function(periods, open, options) {
    options = options || {};
    var daysOfWeek = options.daysOfWeek || ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
    var closedStr = options.closedStr || "Closed";
    var use24HourFormat = options.use24HourFormat || false;

    function formatTime(time) {
      var hours = parseInt(time.substring(0, 2));
      var minutes = time.substring(2);

      if (use24HourFormat) {
        return hours.toString().padStart(2, '0') + ":" + minutes;
      } else {
        var period = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12 || 12;
        return hours + ":" + minutes + " " + period;
      }
    }

    var schedule = {};

    for (var i = 0; i < 7; i++) {
      schedule[i] = [];
    }

    periods.forEach(function(period) {
      var openDay = period.open.day;
      var openTime = formatTime(period.open.time);
      var closeTime = formatTime(period.close.time);
      schedule[openDay].push({
        open: openTime,
        close: closeTime,
        openNum: period.open.time
      });
    });

    for (var day in schedule) {
      schedule[day].sort(function(a, b) {
        return parseInt(a.openNum.replace(/[^0-9]/g, '')) - parseInt(b.openNum.replace(/[^0-9]/g, ''));
      });
    }

    var html = [];
    var value_text_align_class = DRTS.bsPrefix + (DRTS.isRTL ? 'text-left' : 'text-right');
    html.push('<div class="' + DRTS.bsPrefix + 'list-group ' + DRTS.bsPrefix + 'list-group-flush drts-entity-fieldlist drts-directory-opening-hours">');
    for (var _day in schedule) {
      var dayName = daysOfWeek[_day];
      var _periods = schedule[_day].map(function(period) {
        return period.open + " - " + period.close;
      });
      html.push('<div class="' + DRTS.bsPrefix + 'list-group-item ' + DRTS.bsPrefix + 'px-0"><div class="drts-entity-field ' + DRTS.bsPrefix + 'justify-content-between">');
      html.push('<div class="drts-entity-field-label">' + dayName + '</div>');
      html.push('<div class="drts-entity-field-value ' + value_text_align_class + '">' + (_periods.length ? _periods.join(', ') : closedStr) + '</div>');
      html.push("</div></div>");
    }
    html.push("</div>");
    return html.join("\n");
  };
})(jQuery);